/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import java.time.ZoneOffset;

/**
 * Represents intensity of an activity.
 *
 * <p>Intensity can be either moderate or vigorous.
 *
 * <p>Each record requires the start time, the end time and the activity intensity type.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ActivityIntensityRecord extends android.health.connect.datatypes.IntervalRecord {

ActivityIntensityRecord() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of the activity intensity.
 * @return Value is {@link android.health.connect.datatypes.ActivityIntensityRecord#ACTIVITY_INTENSITY_TYPE_MODERATE}, or {@link android.health.connect.datatypes.ActivityIntensityRecord#ACTIVITY_INTENSITY_TYPE_VIGOROUS}
 */

public int getActivityIntensityType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Moderate activity intensity. */

public static final int ACTIVITY_INTENSITY_TYPE_MODERATE = 0; // 0x0

/** Vigorous activity intensity. */

public static final int ACTIVITY_INTENSITY_TYPE_VIGOROUS = 1; // 0x1

/**
 * Metric identifier to retrieve the total duration of activity intensity regardless of the type
 * using aggregate APIs in {@link android.health.connect.HealthConnectManager}.
 *
 * <p>Equivalent to {@link #MODERATE_DURATION_TOTAL} + {@link #VIGOROUS_DURATION_TOTAL}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.time.Duration> DURATION_TOTAL;
static { DURATION_TOTAL = null; }

/**
 * Metric identifier to retrieve the number of weighted intensity minutes using aggregate APIs
 * in {@link android.health.connect.HealthConnectManager}.
 *
 * <p>Records of type {@link #ACTIVITY_INTENSITY_TYPE_MODERATE} contribute their full duration
 * to the result, while records of type {@link #ACTIVITY_INTENSITY_TYPE_VIGOROUS} contribute
 * double their duration.
 *
 * <p>Equivalent to {@link #MODERATE_DURATION_TOTAL} + 2 * {@link #VIGOROUS_DURATION_TOTAL}
 * rounded to minutes.
 *
 * <p>Calculated in minutes.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> INTENSITY_MINUTES_TOTAL;
static { INTENSITY_MINUTES_TOTAL = null; }

/**
 * Metric identifier to retrieve the total duration of moderate activity intensity using
 * aggregate APIs in {@link android.health.connect.HealthConnectManager}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.time.Duration> MODERATE_DURATION_TOTAL;
static { MODERATE_DURATION_TOTAL = null; }

/**
 * Metric identifier to retrieve the total duration of vigorous activity intensity using
 * aggregate APIs in {@link android.health.connect.HealthConnectManager}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.time.Duration> VIGOROUS_DURATION_TOTAL;
static { VIGOROUS_DURATION_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.ActivityIntensityRecord ActivityIntensityRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity instensity record.
 * This value cannot be {@code null}.
 * @param endTime End time of this activity intensity record.
 
 * This value cannot be {@code null}.

 * @param activityIntensityType Value is {@link android.health.connect.datatypes.ActivityIntensityRecord#ACTIVITY_INTENSITY_TYPE_MODERATE}, or {@link android.health.connect.datatypes.ActivityIntensityRecord#ACTIVITY_INTENSITY_TYPE_VIGOROUS}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, int activityIntensityType) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.health.connect.datatypes.ActivityIntensityRecord ActivityIntensityRecord}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActivityIntensityRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.ZoneOffset ZoneOffset} of the user when the activity ended.
 *
 * <p>Defaults to the system zone offset if not set.
 
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActivityIntensityRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.ZoneOffset ZoneOffset} of the user when the activity started.
 *
 * <p>Defaults to the system zone offset if not set.
 
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ActivityIntensityRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }
}

}

