/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.MedicalResource;
import java.util.List;

/** A read response for {@link android.health.connect.HealthConnectManager#readMedicalResources HealthConnectManager.readMedicalResources}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReadMedicalResourcesResponse implements android.os.Parcelable {

/**
 * Constructs a new {@link android.health.connect.ReadMedicalResourcesResponse ReadMedicalResourcesResponse} instance.
 *
 * @param medicalResources List of {@link android.health.connect.datatypes.MedicalResource MedicalResource}s.
 * This value cannot be {@code null}.
 * @param nextPageToken The token value of the read result which can be used as input token for
 *     next read request. {@code null} if there are no more pages available.
 * @param remainingCount the total number of medical resources remaining, excluding the ones in
 *     this response
 */

public ReadMedicalResourcesResponse(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.MedicalResource> medicalResources, @android.annotation.Nullable java.lang.String nextPageToken, int remainingCount) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns list of {@link android.health.connect.datatypes.MedicalResource MedicalResource}s.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.MedicalResource> getMedicalResources() { throw new RuntimeException("Stub!"); }

/**
 * Returns a page token to read the next page of the result. {@code null} if there are no more
 * pages available.
 */

@android.annotation.Nullable
public java.lang.String getNextPageToken() { throw new RuntimeException("Stub!"); }

/**
 * Returns the count of medical resources still remaining which were not returned due to
 * pagination.
 *
 * <p>For a response with a null next page token, this will be 0. This result is accurate at the
 * time the request was made, and with the permissions when the request was made. However, the
 * actual results may change if permissions change or resources are inserted or deleted.
 */

public int getRemainingCount() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.ReadMedicalResourcesResponse> CREATOR;
static { CREATOR = null; }
}

