/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import android.health.connect.datatypes.FhirResource;
import android.health.connect.datatypes.MedicalDataSource;

/**
 * A class to represent a unique identifier of a medical resource.
 *
 * <p>This class contains a set of properties that together represent a unique identifier of a
 * medical resource.
 *
 * <p>The medical resource data representation follows the <a href="https://hl7.org/fhir/">Fast
 * Healthcare Interoperability Resources (FHIR)</a> standard.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MedicalResourceId implements android.os.Parcelable {

/**
 * Constructs a new {@link android.health.connect.MedicalResourceId MedicalResourceId} instance.
 *
 * @param dataSourceId The unique identifier of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource},
 *     representing where the data comes from.
 * This value cannot be {@code null}.
 * @param fhirResourceType The FHIR resource type. This is the "resourceType" field from a JSON
 *     representation of FHIR resource data.
 * Value is {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_IMMUNIZATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_OBSERVATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_CONDITION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PROCEDURE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_REQUEST}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PATIENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ENCOUNTER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_LOCATION}, or {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ORGANIZATION}
 * @param fhirResourceId The FHIR resource ID. This is the "id" field from a JSON representation
 *     of FHIR resource data.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID, or
 *     {@code fhirResourceType} is not a valid supported type.
 */

public MedicalResourceId(@android.annotation.NonNull java.lang.String dataSourceId, int fhirResourceType, @android.annotation.NonNull java.lang.String fhirResourceId) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Creates a {@link android.health.connect.MedicalResourceId MedicalResourceId} instance from {@code dataSourceId} and {@code
 * fhirReference}.
 *
 * @param dataSourceId The unique identifier of the existing {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource},
 *     representing where the data comes from.
 * This value cannot be {@code null}.
 * @param fhirReference The FHIR reference string typically extracted from the "reference" field
 *     in one FHIR resource (source), pointing to another FHIR resource (target) within the same
 *     data source, for example "Patient/034AB16".
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the provided {@code dataSourceId} is not a valid ID, the
 *     referenced resource type is not a valid {@link android.health.connect.datatypes.FhirResource FhirResource} type supported by Health
 *     Connect, or {@code fhirReference} does not match with the pattern of {@code
 *     $fhir_resource_type/$fhir_resource_id}, where the FHIR resource type should align with
 *     the resource list in <a href="https://build.fhir.org/resourcelist.html">the official FHIR
 *     website</a>, and the FHIR resource ID should also follow the pattern described in <a
 *     href="https://build.fhir.org/datatypes.html#id">the official FHIR datatypes</a>.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.health.connect.MedicalResourceId fromFhirReference(@android.annotation.NonNull java.lang.String dataSourceId, @android.annotation.NonNull java.lang.String fhirReference) { throw new RuntimeException("Stub!"); }

/**
 * Returns the unique {@link android.health.connect.datatypes.MedicalDataSource MedicalDataSource} ID of where the data comes from.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDataSourceId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource ID.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getFhirResourceId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the FHIR resource type.
 * @return Value is {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_IMMUNIZATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_OBSERVATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_CONDITION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PROCEDURE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_REQUEST}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PATIENT}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ENCOUNTER}, {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_LOCATION}, or {@link android.health.connect.datatypes.FhirResource#FHIR_RESOURCE_TYPE_ORGANIZATION}
 */

public int getFhirResourceType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.MedicalResourceId> CREATOR;
static { CREATOR = null; }
}

