/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * Thrown when an error occurs during a Bluetooth Socket related exception.
 *
 * <p>This is currently intended to be thrown for a failure during {@link android.bluetooth.BluetoothSocket BluetoothSocket}
 * operations.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BluetoothSocketException extends java.io.IOException {

/**
 * Create a {@link android.bluetooth.BluetoothSocketException BluetoothSocketException} with an error code. A generic error message is
 * generated based on the {@code code} provided.
 *
 * @param code : error code representing the reason for failure.

 * Value is {@link android.bluetooth.BluetoothSocketException#UNSPECIFIED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNKNOWN}, {@link android.bluetooth.BluetoothSocketException#L2CAP_ACL_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_CLIENT_SECURITY_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHENTICATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHORIZATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPTION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_SOURCE_CID}, {@link android.bluetooth.BluetoothSocketException#L2CAP_SOURCE_CID_ALREADY_ALLOCATED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNACCEPTABLE_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_RESOURCES}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_PSM_AVAILABLE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_TIMEOUT}, {@link android.bluetooth.BluetoothSocketException#BLUETOOTH_OFF_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_MANAGER_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CLOSED}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CONNECTION_FAILURE}, {@link android.bluetooth.BluetoothSocketException#NULL_DEVICE}, {@link android.bluetooth.BluetoothSocketException#RPC_FAILURE}, or {@link android.bluetooth.BluetoothSocketException#UNIX_FILE_SOCKET_CREATION_FAILURE}
 */

public BluetoothSocketException(int code) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.bluetooth.BluetoothSocketException BluetoothSocketException} with an error code and custom error message.
 *
 * @param code : error code representing the reason for failure.
 * Value is {@link android.bluetooth.BluetoothSocketException#UNSPECIFIED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNKNOWN}, {@link android.bluetooth.BluetoothSocketException#L2CAP_ACL_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_CLIENT_SECURITY_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHENTICATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHORIZATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPTION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_SOURCE_CID}, {@link android.bluetooth.BluetoothSocketException#L2CAP_SOURCE_CID_ALREADY_ALLOCATED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNACCEPTABLE_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_RESOURCES}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_PSM_AVAILABLE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_TIMEOUT}, {@link android.bluetooth.BluetoothSocketException#BLUETOOTH_OFF_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_MANAGER_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CLOSED}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CONNECTION_FAILURE}, {@link android.bluetooth.BluetoothSocketException#NULL_DEVICE}, {@link android.bluetooth.BluetoothSocketException#RPC_FAILURE}, or {@link android.bluetooth.BluetoothSocketException#UNIX_FILE_SOCKET_CREATION_FAILURE}
 * @param msg : Custom error message associated to the failure.

 * This value cannot be {@code null}.
 */

public BluetoothSocketException(int code, @android.annotation.NonNull java.lang.String msg) { throw new RuntimeException("Stub!"); }

/**
 * Returns the error code associated to this failure.
 * @return Value is {@link android.bluetooth.BluetoothSocketException#UNSPECIFIED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNKNOWN}, {@link android.bluetooth.BluetoothSocketException#L2CAP_ACL_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_CLIENT_SECURITY_FAILURE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHENTICATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_AUTHORIZATION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INSUFFICIENT_ENCRYPTION}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_SOURCE_CID}, {@link android.bluetooth.BluetoothSocketException#L2CAP_SOURCE_CID_ALREADY_ALLOCATED}, {@link android.bluetooth.BluetoothSocketException#L2CAP_UNACCEPTABLE_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_INVALID_PARAMETERS}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_RESOURCES}, {@link android.bluetooth.BluetoothSocketException#L2CAP_NO_PSM_AVAILABLE}, {@link android.bluetooth.BluetoothSocketException#L2CAP_TIMEOUT}, {@link android.bluetooth.BluetoothSocketException#BLUETOOTH_OFF_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_MANAGER_FAILURE}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CLOSED}, {@link android.bluetooth.BluetoothSocketException#SOCKET_CONNECTION_FAILURE}, {@link android.bluetooth.BluetoothSocketException#NULL_DEVICE}, {@link android.bluetooth.BluetoothSocketException#RPC_FAILURE}, or {@link android.bluetooth.BluetoothSocketException#UNIX_FILE_SOCKET_CREATION_FAILURE}
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * Error code returned by {@link android.bluetooth.BluetoothSocket BluetoothSocket} during a socket operation that failed because
 * Bluetooth is turned off.
 */

public static final int BLUETOOTH_OFF_FAILURE = 15; // 0xf

/** Error code during connect when there is an ACL connection failure. */

public static final int L2CAP_ACL_FAILURE = 2; // 0x2

/**
 * Error code during connect when security clearance fails on the client during L2CAP
 * connection.
 */

public static final int L2CAP_CLIENT_SECURITY_FAILURE = 3; // 0x3

/**
 * Error code during connect when authentication fails on the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_INSUFFICIENT_AUTHENTICATION = 4; // 0x4

/**
 * Error code during connect when authorization fails on the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_INSUFFICIENT_AUTHORIZATION = 5; // 0x5

/**
 * Error code during connect for insufficient encryption from the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_INSUFFICIENT_ENCRYPTION = 7; // 0x7

/**
 * Error code during connect indicating insufficient encryption key size on the peer device
 * during L2CAP connection.
 */

public static final int L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE = 6; // 0x6

/**
 * Error code during connect for invalid parameters from the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_INVALID_PARAMETERS = 11; // 0xb

/**
 * Error code during connect for invalid Channel ID from the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_INVALID_SOURCE_CID = 8; // 0x8

/** Error code during connect when no PSM is available for L2CAP connection. */

public static final int L2CAP_NO_PSM_AVAILABLE = 13; // 0xd

/** Error code during connect when no resources are available for L2CAP connection. */

public static final int L2CAP_NO_RESOURCES = 12; // 0xc

/**
 * Error code during connect for already allocated Channel ID from the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_SOURCE_CID_ALREADY_ALLOCATED = 9; // 0x9

/** Error code during connect when L2CAP connection timeout. */

public static final int L2CAP_TIMEOUT = 14; // 0xe

/**
 * Error code during connect for unacceptable Parameters from the peer device during L2CAP
 * connection.
 */

public static final int L2CAP_UNACCEPTABLE_PARAMETERS = 10; // 0xa

/**
 * Error code returned by {@link android.bluetooth.BluetoothSocket BluetoothSocket} during a L2CAP-related socket operation that
 * failed for an unknown reason.
 */

public static final int L2CAP_UNKNOWN = 1; // 0x1

/** Error code during connect when null device attempts to do socket connection. */

public static final int NULL_DEVICE = 19; // 0x13

/** Error code during connect when a Runtime RPC exception occurs. */

public static final int RPC_FAILURE = 20; // 0x14

/**
 * Error code returned by {@link android.bluetooth.BluetoothSocket BluetoothSocket} during a socket operation that failed because
 * the socket has been closed.
 */

public static final int SOCKET_CLOSED = 17; // 0x11

/** Error code during connect for generic socket connection failures. */

public static final int SOCKET_CONNECTION_FAILURE = 18; // 0x12

/**
 * Error code returned by {@link android.bluetooth.BluetoothSocket BluetoothSocket} during a socket operation that failed because
 * socket manager is not available.
 */

public static final int SOCKET_MANAGER_FAILURE = 16; // 0x10

/** Error code during connect when the UNIX socket connection creation fails. */

public static final int UNIX_FILE_SOCKET_CREATION_FAILURE = 21; // 0x15

/**
 * Error code representing a failure during {@link android.bluetooth.BluetoothSocket BluetoothSocket}. The reason for failure
 * isn't specified.
 */

public static final int UNSPECIFIED = 0; // 0x0
}

