/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;


/**
 * Represents a channel for an SDK in the sandbox process to interact with the app.
 *
 * <p>The SDK and the app can agree on a binder interface to be implemented by the app and shared
 * via an object of {@link android.app.sdksandbox.AppOwnedSdkSandboxInterface AppOwnedSdkSandboxInterface}.
 *
 * <p>The app registers the AppOwnedSdkSandboxInterfaces using {@link android.app.sdksandbox.SdkSandboxManager#registerAppOwnedSdkSandboxInterface  }.
 *
 * <p>The SDK in sandbox process can then query the list of registered AppOwnedSdkSandboxInterfaces
 * using {@link
 * android.app.sdksandbox.sdkprovider.SdkSandboxController#getAppOwnedSdkSandboxInterfaces}.
 *
 * <p>Once SDK has the AppOwnedSdkSandboxInterface it wants to communicate with, it will have to
 * cast the binder object from {@link #getInterface} to the prearranged interface before initiating
 * the communication.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppOwnedSdkSandboxInterface implements android.os.Parcelable {

/**
 * @param name This value cannot be {@code null}.

 * @param binder This value cannot be {@code null}.
 */

public AppOwnedSdkSandboxInterface(@android.annotation.NonNull java.lang.String name, long version, @android.annotation.NonNull android.os.IBinder binder) { throw new RuntimeException("Stub!"); }

/** {@inheritDoc} */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns binder object associated with AppOwnedSdkSandboxInterface.
 *
 * <p>The SDK and the app can agree on a binder interface to be implemented by the app and
 * shared via this object, see {@link android.app.sdksandbox.AppOwnedSdkSandboxInterface AppOwnedSdkSandboxInterface}.
 *
 * <p>The SDK in the sandbox will have to cast the binder object received from this method to
 * the agreed upon interface before using it.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.IBinder getInterface() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name used to register the AppOwnedSdkSandboxInterface.
 *
 * <p>App can register only one interface of given name.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the version used to register the AppOwnedSdkSandboxInterface.
 *
 * <p>A version may be chosen by an app, and used to communicate any updates the app makes to
 * this implementation.
 */

public long getVersion() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.sdksandbox.AppOwnedSdkSandboxInterface> CREATOR;
static { CREATOR = null; }
}

