/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch.util;

import android.app.appsearch.GenericDocument;
import android.app.appsearch.JoinSpec;

/** A util class with methods for working with document ids. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DocumentIdUtil {

DocumentIdUtil() { throw new RuntimeException("Stub!"); }

/**
 * Generates a qualified id based on package, database, and a {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * @param packageName The package the document belongs to.
 * @param databaseName The database containing the document.
 * @param document The document to generate a qualified id for.
 * @return the qualified id of a document.
 * @see #createQualifiedId(String, String, String, String)
 */

@android.annotation.NonNull
public static java.lang.String createQualifiedId(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull android.app.appsearch.GenericDocument document) { throw new RuntimeException("Stub!"); }

/**
 * Generates a qualified id based on package, database, namespace, and doc id.
 *
 * <p>A qualified id is a String referring to the combined package name, database name,
 * namespace, and id of the document. It is useful for linking one document to another in order
 * to perform a join operation with {@link android.app.appsearch.JoinSpec JoinSpec}.
 *
 * @param packageName The package the document belongs to.
 * @param databaseName The database containing the document.
 * @param namespace The namespace of the document.
 * @param id The id of the document.
 * @return the qualified id of a document
 * @see android.app.appsearch.JoinSpec
 * @see android.app.appsearch.JoinSpec#QUALIFIED_ID
 */

@android.annotation.NonNull
public static java.lang.String createQualifiedId(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }
}

