/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.topics;

import android.content.Context;
import java.util.concurrent.Executor;

/**
 * TopicsManager provides APIs for App and Ad-Sdks to get the user interest topics in a privacy
 * preserving way.
 *
 * <p>The instance of the {@link android.adservices.topics.TopicsManager TopicsManager} can be obtained using {@link android.content.Context#getSystemService  } and {@link android.adservices.topics.TopicsManager TopicsManager} class.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TopicsManager {

TopicsManager() { throw new RuntimeException("Stub!"); }

/**
 * Factory method for creating an instance of TopicsManager.
 *
 * @param context The {@link android.content.Context Context} to use
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.topics.TopicsManager TopicsManager} instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.topics.TopicsManager get(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return the topics.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_TOPICS}
 * @param getTopicsRequest The request for obtaining Topics.
 * This value cannot be {@code null}.
 * @param executor The executor to run callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback The callback that's called after topics are available or an error occurs.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalStateException if this API is not available.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public void getTopics(@android.annotation.NonNull android.adservices.topics.GetTopicsRequest getTopicsRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.topics.GetTopicsResponse,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }
}

