/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * The result that should be returned by
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onWebTrigger(android.adservices.ondevicepersonalization.WebTriggerInput,android.os.OutcomeReceiver) IsolatedWorker.onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}.
 * This class contains data that should be written to the REQUESTS or EVENTS tables.
 * The contents of these tables can be consumed by Federated Learning facilitated model training,
 * or Federated Analytics facilitated cross-device statistical analysis.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WebTriggerOutput {

WebTriggerOutput() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * A list of {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} objects to be written to the EVENTS table. Each
 * {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} must be associated with an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} in
 * the REQUESTS table, specified using
 * {@link android.adservices.ondevicepersonalization.EventLogRecord.Builder#setRequestLogRecord(android.adservices.ondevicepersonalization.RequestLogRecord) EventLogRecord.Builder.setRequestLogRecord(RequestLogRecord)}.
 * If the {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} is not specified, the {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} will not be
 * written. The list can be empty if no data needs to be written to the EVENTS table.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> getEventLogRecords() { throw new RuntimeException("Stub!"); }

/**
 * Persistent data to be written to the REQUESTS table after
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onWebTrigger(android.adservices.ondevicepersonalization.WebTriggerInput,android.os.OutcomeReceiver) IsolatedWorker.onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}
 * completes. This can be {@code null} if no data needs to be written to
 * the REQUESTS table.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RequestLogRecord getRequestLogRecord() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.WebTriggerOutput WebTriggerOutput}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @see #setEventLogRecords
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.WebTriggerOutput.Builder addEventLogRecord(@android.annotation.NonNull android.adservices.ondevicepersonalization.EventLogRecord value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.WebTriggerOutput build() { throw new RuntimeException("Stub!"); }

/**
 * A list of {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} objects to be written to the EVENTS table. Each
 * {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} must be associated with an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} in
 * the REQUESTS table, specified using
 * {@link android.adservices.ondevicepersonalization.EventLogRecord.Builder#setRequestLogRecord(android.adservices.ondevicepersonalization.RequestLogRecord) EventLogRecord.Builder.setRequestLogRecord(RequestLogRecord)}.
 * If the {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} is not specified, the {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} will not be
 * written. The list can be empty if no data needs to be written to the EVENTS table.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.WebTriggerOutput.Builder setEventLogRecords(@android.annotation.NonNull java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> value) { throw new RuntimeException("Stub!"); }

/**
 * Persistent data to be written to the REQUESTS table after
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onWebTrigger(android.adservices.ondevicepersonalization.WebTriggerInput,android.os.OutcomeReceiver) IsolatedWorker.onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}
 * completes. This can be {@code null} if no data needs to be written to
 * the REQUESTS table.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.WebTriggerOutput.Builder setRequestLogRecord(@android.annotation.Nullable android.adservices.ondevicepersonalization.RequestLogRecord value) { throw new RuntimeException("Stub!"); }
}

}

