/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/** The output data of {@link android.adservices.ondevicepersonalization.IsolatedWorker#onTrainingExamples IsolatedWorker.onTrainingExamples} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TrainingExamplesOutput {

TrainingExamplesOutput() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * The list of training example byte arrays. The format is a binary serialized <a
 * href="https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/example/example.proto">
 * tensorflow.Example</a> proto. The maximum allowed example size is 50KB.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.ondevicepersonalization.TrainingExampleRecord> getTrainingExampleRecords() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** A builder for {@link android.adservices.ondevicepersonalization.TrainingExamplesOutput TrainingExamplesOutput} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @see #setTrainingExampleRecords
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExamplesOutput.Builder addTrainingExampleRecord(@android.annotation.NonNull android.adservices.ondevicepersonalization.TrainingExampleRecord value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExamplesOutput build() { throw new RuntimeException("Stub!"); }

/**
 * The list of training example byte arrays. The format is a binary serialized <a
 * href="https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/example/example.proto">
 * tensorflow.Example</a> proto. The maximum allowed example size is 50KB.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExamplesOutput.Builder setTrainingExampleRecords(@android.annotation.NonNull java.util.List<android.adservices.ondevicepersonalization.TrainingExampleRecord> value) { throw new RuntimeException("Stub!"); }
}

}

