/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.os.PersistableBundle;

/**
 * The input data for {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker.onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExecuteInput {

/** Creates an {@link android.adservices.ondevicepersonalization.ExecuteInput ExecuteInput}.
 *
 * @param appPackageName the package name of the calling app.
 * This value cannot be {@code null}.
 * @param appParams the parameters provided by the app to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The
 * service defines the expected keys in this {@link android.os.PersistableBundle PersistableBundle}.

 * This value cannot be {@code null}.
 */

public ExecuteInput(@android.annotation.NonNull java.lang.String appPackageName, @android.annotation.NonNull android.os.PersistableBundle appParams) { throw new RuntimeException("Stub!"); }

/**
 * The package name of the calling app.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAppPackageName() { throw new RuntimeException("Stub!"); }

/**
 * The parameters provided by the app to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The service
 * defines the expected keys in this {@link android.os.PersistableBundle PersistableBundle}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.PersistableBundle getAppParams() { throw new RuntimeException("Stub!"); }
}

