/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.content.ComponentName;
import android.os.PersistableBundle;

/** The request of {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#executeInIsolatedService OnDevicePersonalizationManager.executeInIsolatedService}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ExecuteInIsolatedServiceRequest {

ExecuteInIsolatedServiceRequest() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.os.PersistableBundle PersistableBundle} that is passed from the calling app to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The expected contents of this parameter are defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret this parameter.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.PersistableBundle getAppParams() { throw new RuntimeException("Stub!"); }

/**
 * The set of spec to indicate output of {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. It's mainly used by platform.
 * For example, platform calls {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#getOutputType OutputSpec.getOutputType} and validates the result
 * received from {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec getOutputSpec() { throw new RuntimeException("Stub!"); }

/**
 * The {@link android.content.ComponentName ComponentName} of the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.content.ComponentName getService() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** A builder for {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest ExecuteInIsolatedServiceRequest} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new Builder.
 *
 * @param service The {@link android.content.ComponentName ComponentName} of the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.content.ComponentName service) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest build() { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.os.PersistableBundle PersistableBundle} that is passed from the calling app to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The expected contents of this parameter are defined by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The platform does not interpret this parameter.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.Builder setAppParams(@android.annotation.NonNull android.os.PersistableBundle value) { throw new RuntimeException("Stub!"); }

/**
 * The set of spec to indicate output of {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. It's mainly used by
 * platform. If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec OutputSpec} is set to {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#DEFAULT OutputSpec.DEFAULT},
 * OnDevicePersonalization will ignore result returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec OutputSpec} is built with {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#buildBestValueSpec OutputSpec.buildBestValueSpec}, OnDevicePersonalization
 * will verify {@link android.adservices.ondevicepersonalization.ExecuteOutput#getBestValue() ExecuteOutput.getBestValue()} returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}
 * within the max value range set in {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#getMaxIntValue OutputSpec.getMaxIntValue} and add noise.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.Builder setOutputSpec(@android.annotation.NonNull android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec value) { throw new RuntimeException("Stub!"); }
}

/**
 * The set of spec to indicate output of {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. It's mainly used by platform.
 * If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec OutputSpec} is set to {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#DEFAULT OutputSpec.DEFAULT}, OnDevicePersonalization will
 * ignore result returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec OutputSpec} is built with {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#buildBestValueSpec  }, OnDevicePersonalization will verify {@link android.adservices.ondevicepersonalization.ExecuteOutput#getBestValue()  } returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} within the max value range
 * set in {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#getMaxIntValue OutputSpec.getMaxIntValue} and add noise.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class OutputSpec {

OutputSpec() { throw new RuntimeException("Stub!"); }

/**
 * Creates the output spec to get best value out of {@code maxIntValue}. If set this, caller
 * can call {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse#getBestValue ExecuteInIsolatedServiceResponse.getBestValue} to get result.
 *
 * @param maxIntValue the maximum value {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} can return to caller app.
 
 * Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec buildBestValueSpec(int maxIntValue) { throw new RuntimeException("Stub!"); }

/**
 * Returns the value set in {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#buildBestValueSpec OutputSpec.buildBestValueSpec}. The value is expected to
 * be {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse#DEFAULT_BEST_VALUE ExecuteInIsolatedServiceResponse.DEFAULT_BEST_VALUE} if {@link #getOutputType}
 * is {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_NULL OutputSpec.OUTPUT_TYPE_NULL}.

 * @return Value is DEFAULT_BEST_VALUE or greater
 */

public int getMaxIntValue() { throw new RuntimeException("Stub!"); }

/**
 * Returns the output type of {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. The default value is {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_NULL  }.

 * @return Value is {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_NULL}, or {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_BEST_VALUE}
 */

public int getOutputType() { throw new RuntimeException("Stub!"); }

/** The default value of {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec OutputSpec}. */

@android.annotation.NonNull public static final android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec DEFAULT;
static { DEFAULT = null; }

/**
 * If set, {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse#getBestValue() ExecuteInIsolatedServiceResponse.getBestValue()} will return an integer
 * that indicates the index of best values passed in {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest#getAppParams  }.
 */

public static final int OUTPUT_TYPE_BEST_VALUE = 1; // 0x1

/**
 * The default value of OutputType. If set, OnDevicePersonalization will ignore result
 * returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse ExecuteInIsolatedServiceResponse} doesn't
 * return any output data.
 */

public static final int OUTPUT_TYPE_NULL = 0; // 0x0
}

}

