/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import java.util.concurrent.Executor;

/** TestCustomAudienceManager provides APIs for app and ad-SDKs to test custom audiences. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TestCustomAudienceManager {

TestCustomAudienceManager() { throw new RuntimeException("Stub!"); }

/**
 * Overrides the Custom Audience API to avoid fetching data from remote servers and use the data
 * provided in {@link android.adservices.customaudience.AddCustomAudienceOverrideRequest AddCustomAudienceOverrideRequest} instead. The {@link android.adservices.customaudience.AddCustomAudienceOverrideRequest AddCustomAudienceOverrideRequest} is provided by the Ads SDK.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <p>This call will fail silently if the {@code owner} in the {@code request} is not the
 * calling app's package name.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void overrideCustomAudienceRemoteInfo(@android.annotation.NonNull android.adservices.customaudience.AddCustomAudienceOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes an override in th Custom Audience API with associated the data in {@link android.adservices.customaudience.RemoveCustomAudienceOverrideRequest RemoveCustomAudienceOverrideRequest}.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The {@link android.adservices.customaudience.RemoveCustomAudienceOverrideRequest RemoveCustomAudienceOverrideRequest} is provided by the Ads SDK. The
 *     receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception}
 *     indicates the error.
 
 * @param request This value cannot be {@code null}.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void removeCustomAudienceRemoteInfoOverride(@android.annotation.NonNull android.adservices.customaudience.RemoveCustomAudienceOverrideRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Removes all override data in the Custom Audience API.
 *
 * <p>This method is intended to be used for end-to-end testing. This API is enabled only for
 * apps in debug mode with developer options enabled.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_CUSTOM_AUDIENCE}
 * @throws java.lang.IllegalStateException if this API is not enabled for the caller
 *     <p>The receiver either returns a {@code void} for a successful run, or an {@link java.lang.Exception Exception} indicates the error.

 * @param executor This value cannot be {@code null}.
 
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.

 * @param receiver This value cannot be {@code null}.
 */

public void resetAllCustomAudienceOverrides(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Object,java.lang.Exception> receiver) { throw new RuntimeException("Stub!"); }
}

