/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import java.time.Instant;

/**
 * Represents a partial custom audience that is passed along to the buyer ad tech, when scheduling a
 * delayed update for Custom Audience. Any field set by the caller cannot be overridden by the
 * custom audience fetched from the {@code updateUri}
 *
 * <p>Given multiple Custom Audiences could be returned by the buyer, we will match the override
 * restriction based on the name of Custom Audience. Thus name would be a required field.
 *
 * <p>Other nullable fields will not be overridden if left null
 *
 * <p>For more information about each field refer to {@link android.adservices.customaudience.CustomAudience CustomAudience}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PartialCustomAudience implements android.os.Parcelable {

PartialCustomAudience() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @return {@code true} only if two {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} objects contain the same
 *     information.
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getActivationTime() CustomAudience.getActivationTime()} for details. Will not be overridden if
 * left null.
 *
 * @return the {@link java.time.Instant Instant} by which joining the custom audience will be delayed.
 */

@android.annotation.Nullable
public java.time.Instant getActivationTime() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getExpirationTime() CustomAudience.getExpirationTime()} for details. Will not be overridden if
 * left null.
 *
 * @return the {@link java.time.Instant Instant} by when the membership to the custom audience will expire.
 */

@android.annotation.Nullable
public java.time.Instant getExpirationTime() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getName() CustomAudience.getName()} for details.
 *
 * @return the {@link java.lang.String String} name of the custom audience to join.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Reference {@link android.adservices.customaudience.CustomAudience#getUserBiddingSignals() CustomAudience.getUserBiddingSignals()} for details. Will not be overridden
 * if left null.
 *
 * @return the buyer signals to be consumed by the buyer-provided JavaScript when the custom
 *     audience participates in an ad selection.
 */

@android.annotation.Nullable
public android.adservices.common.AdSelectionSignals getUserBiddingSignals() { throw new RuntimeException("Stub!"); }

/**
 * @return the hash of the {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} object's data.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * @return a human-readable representation of {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience}.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.customaudience.PartialCustomAudience> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.customaudience.PartialCustomAudience PartialCustomAudience} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Instantiates a {@link android.adservices.customaudience.PartialCustomAudience.Builder PartialCustomAudience.Builder} with a {@link java.lang.String String} name for which
 * this Partial Custom Audience will be updated

 * @param name This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of a {@link android.adservices.customaudience.FetchAndJoinCustomAudienceRequest FetchAndJoinCustomAudienceRequest}.
 *
 * @throws java.lang.NullPointerException if any non-null parameter is null.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.PartialCustomAudience build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.Instant Instant} by which joining the custom audience will be delayed.
 *
 * <p>See {@link #getActivationTime()} for details.
 
 * @param activationTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.PartialCustomAudience.Builder setActivationTime(@android.annotation.Nullable java.time.Instant activationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link java.time.Instant Instant} by when the membership to the custom audience will expire.
 *
 * <p>See {@link #getExpirationTime()} for details.
 
 * @param expirationTime This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.PartialCustomAudience.Builder setExpirationTime(@android.annotation.Nullable java.time.Instant expirationTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer signals to be consumed by the buyer-provided JavaScript when the custom
 * audience participates in an ad selection.
 *
 * <p>See {@link #getUserBiddingSignals()} for details.
 
 * @param userBiddingSignals This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.PartialCustomAudience.Builder setUserBiddingSignals(@android.annotation.Nullable android.adservices.common.AdSelectionSignals userBiddingSignals) { throw new RuntimeException("Stub!"); }
}

}

