/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import java.util.Objects;

/**
 * Contains a list of buyer supplied {@link android.adservices.adselection.AdWithBid AdWithBid} bundle and its signature.
 *
 * <p>Instances of this class are created by SDKs to be injected as part of {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} and passed to {@link android.adservices.adselection.AdSelectionManager#selectAds AdSelectionManager.selectAds}
 *
 * <p>SignedContextualAds are signed using ECDSA algorithm with SHA256 hashing algorithm (aka
 * SHA256withECDSA). Keys used should belong to P-256 curve (aka “secp256r1” or “prime256v1”).
 *
 * <p>Signature should include the buyer, decisionLogicUri and adsWithBid fields.
 *
 * <p>While creating the signature a specific serialization rules must be followed as it's outlined
 * here:
 *
 * <ul>
 *   <li>{@code Objects} concatenate the serialized values of their fields with the {@code |} (pipe)
 *       in between each field
 *   <li>{@code All fields} are sorted by alphabetical order within the object
 *   <li>{@code Nullable fields} are skipped if they are null/unset
 *   <li>{@code Doubles} are converted to String preserving precision
 *   <li>{@code Integers} are converted to string values
 *   <li>{@code Sets} are sorted alphabetically
 *   <li>{@code Lists} keep the same order
 *   <li>{@code Strings} get encoded into byte[] using UTF-8 encoding
 * </ul>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SignedContextualAds implements android.os.Parcelable {

SignedContextualAds() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * @return the Ad data with bid value associated with this ad

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.adselection.AdWithBid> getAdsWithBid() { throw new RuntimeException("Stub!"); }

/**
 * @return the Ad tech identifier from which this contextual Ad would have been downloaded

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * @return the URI used to retrieve the updateBid() and reportWin() function used during the ad
 *     selection and reporting process

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getDecisionLogicUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns a copy of the signature for the contextual ads object.
 *
 * <p>See {@link android.adservices.adselection.SignedContextualAds SignedContextualAds} for more details.
 *
 * @return the signature

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getSignature() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.SignedContextualAds> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.adselection.SignedContextualAds SignedContextualAds} object */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.adservices.adselection.SignedContextualAds.Builder SignedContextualAds.Builder} from a {@link android.adservices.adselection.SignedContextualAds SignedContextualAds}.
 * @param signedContextualAds This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.adservices.adselection.SignedContextualAds signedContextualAds) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.SignedContextualAds SignedContextualAds} instance.
 *
 * @throws java.lang.NullPointerException if any required params are null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SignedContextualAds build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the Ads with pre-defined bid values
 *
 * <p>See {@link #getAdsWithBid()} for more details
 
 * @param adsWithBid This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SignedContextualAds.Builder setAdsWithBid(@android.annotation.NonNull java.util.List<android.adservices.adselection.AdWithBid> adsWithBid) { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer Ad tech Identifier
 *
 * <p>See {@link #getBuyer()} for more details
 
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SignedContextualAds.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the URI to fetch the decision logic used in ad selection and reporting
 *
 * <p>See {@link #getDecisionLogicUri()} for more details
 
 * @param decisionLogicUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SignedContextualAds.Builder setDecisionLogicUri(@android.annotation.NonNull android.net.Uri decisionLogicUri) { throw new RuntimeException("Stub!"); }

/**
 * Sets the copied signature
 * @param signature This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.SignedContextualAds.Builder setSignature(@android.annotation.NonNull byte[] signature) { throw new RuntimeException("Stub!"); }
}

}

