/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * This POJO represents the {@link android.adservices.adselection.TestAdSelectionManager#removeAdSelectionConfigRemoteInfoOverride(android.adservices.adselection.RemoveAdSelectionOverrideRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver) TestAdSelectionManager.removeAdSelectionConfigRemoteInfoOverride(
 * RemoveAdSelectionOverrideRequest, Executor, OutcomeReceiver)} request
 *
 * <p>It contains one field, a {@link android.adservices.adselection.AdSelectionConfig AdSelectionConfig} which serves as the identifier of the
 * override to be removed
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RemoveAdSelectionOverrideRequest {

/**
 * Builds a {@link android.adservices.adselection.RemoveAdSelectionOverrideRequest RemoveAdSelectionOverrideRequest} instance.
 * @param adSelectionConfig This value cannot be {@code null}.
 */

public RemoveAdSelectionOverrideRequest(@android.annotation.NonNull android.adservices.adselection.AdSelectionConfig adSelectionConfig) { throw new RuntimeException("Stub!"); }

/**
 * @return AdSelectionConfig, the configuration of the ad selection process.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionConfig getAdSelectionConfig() { throw new RuntimeException("Stub!"); }
}

