/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.accessibilityservice;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface BrailleDisplayController {

public void connect(@android.annotation.NonNull android.bluetooth.BluetoothDevice bluetoothDevice, @android.annotation.NonNull android.accessibilityservice.BrailleDisplayController.BrailleDisplayCallback callback);

public void connect(@android.annotation.NonNull android.bluetooth.BluetoothDevice bluetoothDevice, @android.annotation.NonNull java.util.concurrent.Executor callbackExecutor, @android.annotation.NonNull android.accessibilityservice.BrailleDisplayController.BrailleDisplayCallback callback);

public void connect(@android.annotation.NonNull android.hardware.usb.UsbDevice usbDevice, @android.annotation.NonNull android.accessibilityservice.BrailleDisplayController.BrailleDisplayCallback callback);

public void connect(@android.annotation.NonNull android.hardware.usb.UsbDevice usbDevice, @android.annotation.NonNull java.util.concurrent.Executor callbackExecutor, @android.annotation.NonNull android.accessibilityservice.BrailleDisplayController.BrailleDisplayCallback callback);

public void disconnect();

public boolean isConnected();

public void write(@android.annotation.NonNull byte[] buffer) throws java.io.IOException;
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface BrailleDisplayCallback {

public void onConnected(@android.annotation.NonNull byte[] hidDescriptor);

public void onConnectionFailed(int errorFlags);

public void onDisconnected();

public void onInput(@android.annotation.NonNull byte[] input);

public static final int FLAG_ERROR_BRAILLE_DISPLAY_NOT_FOUND = 2; // 0x2

public static final int FLAG_ERROR_CANNOT_ACCESS = 1; // 0x1
}

}

