/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.net.MacAddress;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pDirInfo;
import android.net.wifi.p2p.WifiP2pDiscoveryConfig;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig;
import android.net.wifi.p2p.WifiP2pUsdBasedServiceDiscoveryConfig;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceResponse;
import android.os.Looper;
import android.os.OutcomeReceiver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class WifiP2pManager {
    public static final String ACTION_WIFI_P2P_LISTEN_STATE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_LISTEN_STATE_CHANGED";
    public static final String ACTION_WIFI_P2P_REQUEST_RESPONSE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_REQUEST_RESPONSE_CHANGED";
    public static final int BUSY = 2;
    public static final int CONNECTION_REQUEST_ACCEPT = 0;
    public static final int CONNECTION_REQUEST_DEFER_SHOW_PIN_TO_SERVICE = 3;
    public static final int CONNECTION_REQUEST_DEFER_TO_SERVICE = 2;
    public static final int CONNECTION_REQUEST_REJECT = 1;
    public static final int ERROR = 0;
    public static final String EXTRA_DISCOVERY_STATE = "discoveryState";
    public static final String EXTRA_LISTEN_STATE = "android.net.wifi.p2p.extra.LISTEN_STATE";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_P2P_DEVICE_LIST = "wifiP2pDeviceList";
    public static final String EXTRA_REQUEST_CONFIG = "android.net.wifi.p2p.extra.REQUEST_CONFIG";
    public static final String EXTRA_REQUEST_RESPONSE = "android.net.wifi.p2p.extra.REQUEST_RESPONSE";
    public static final String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";
    public static final String EXTRA_WIFI_P2P_GROUP = "p2pGroupInfo";
    public static final String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";
    public static final String EXTRA_WIFI_STATE = "wifi_p2p_state";
    public static final int GROUP_CREATION_FAILURE_REASON_CONNECTION_CANCELLED = 0;
    public static final int GROUP_CREATION_FAILURE_REASON_GROUP_REMOVED = 4;
    public static final int GROUP_CREATION_FAILURE_REASON_INVITATION_FAILED = 5;
    public static final int GROUP_CREATION_FAILURE_REASON_PROVISION_DISCOVERY_FAILED = 3;
    public static final int GROUP_CREATION_FAILURE_REASON_TIMED_OUT = 1;
    public static final int GROUP_CREATION_FAILURE_REASON_USER_REJECTED = 2;
    public static final int NO_PERMISSION = 4;
    public static final int NO_SERVICE_REQUESTS = 3;
    public static final int P2P_UNSUPPORTED = 1;
    public static final String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";
    public static final String WIFI_P2P_DISCOVERY_CHANGED_ACTION = "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE";
    public static final int WIFI_P2P_DISCOVERY_STARTED = 2;
    public static final int WIFI_P2P_DISCOVERY_STOPPED = 1;
    public static final int WIFI_P2P_LISTEN_STARTED = 2;
    public static final int WIFI_P2P_LISTEN_STOPPED = 1;
    public static final String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";
    public static final int WIFI_P2P_SCAN_FULL = 0;
    public static final int WIFI_P2P_SCAN_SINGLE_FREQ = 2;
    public static final int WIFI_P2P_SCAN_SOCIAL = 1;
    public static final String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";
    public static final int WIFI_P2P_STATE_DISABLED = 1;
    public static final int WIFI_P2P_STATE_ENABLED = 2;
    public static final String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";

    WifiP2pManager() {
        throw new RuntimeException("Stub!");
    }

    public void addExternalApprover(@NonNull Channel c, @NonNull MacAddress deviceAddress, @NonNull ExternalApproverRequestListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void addLocalService(Channel channel, WifiP2pServiceInfo servInfo, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void addServiceRequest(Channel channel, WifiP2pServiceRequest req, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void cancelConnect(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearLocalServices(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearServiceRequests(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void connect(Channel channel, WifiP2pConfig config, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void createGroup(@NonNull Channel channel, @Nullable WifiP2pConfig config, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void createGroup(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void discoverPeers(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void discoverPeersOnSocialChannels(@NonNull Channel channel, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void discoverPeersOnSpecificFrequency(@NonNull Channel channel, int frequencyMhz, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void discoverServices(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void discoverUsdBasedServices(@NonNull Channel channel, @NonNull WifiP2pUsdBasedServiceDiscoveryConfig config, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void getListenState(@NonNull Channel c, @NonNull Executor executor, @NonNull Consumer<Integer> resultsCallback) {
        throw new RuntimeException("Stub!");
    }

    public static int getP2pMaxAllowedVendorElementsLengthBytes() {
        throw new RuntimeException("Stub!");
    }

    public Channel initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        throw new RuntimeException("Stub!");
    }

    public boolean isChannelConstrainedDiscoverySupported() {
        throw new RuntimeException("Stub!");
    }

    public boolean isGroupClientRemovalSupported() {
        throw new RuntimeException("Stub!");
    }

    public boolean isGroupOwnerIPv6LinkLocalAddressProvided() {
        throw new RuntimeException("Stub!");
    }

    public boolean isPccModeSupported() {
        throw new RuntimeException("Stub!");
    }

    public boolean isSetVendorElementsSupported() {
        throw new RuntimeException("Stub!");
    }

    public boolean isWiFiDirectR2Supported() {
        throw new RuntimeException("Stub!");
    }

    public void registerWifiP2pListener(@NonNull Executor executor, @NonNull WifiP2pListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void removeClient(@NonNull Channel channel, @NonNull MacAddress peerAddress, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void removeExternalApprover(@NonNull Channel c, @NonNull MacAddress deviceAddress, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void removeGroup(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void removeLocalService(Channel channel, WifiP2pServiceInfo servInfo, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void removeServiceRequest(Channel channel, WifiP2pServiceRequest req, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestConnectionInfo(Channel channel, ConnectionInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestDeviceInfo(@NonNull Channel c, @NonNull DeviceInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestDirInfo(@NonNull Channel c, @NonNull Executor executor, @NonNull OutcomeReceiver<WifiP2pDirInfo, Exception> callback) {
        throw new RuntimeException("Stub!");
    }

    public void requestDiscoveryState(@NonNull Channel c, @NonNull DiscoveryStateListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestGroupInfo(Channel channel, GroupInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestNetworkInfo(@NonNull Channel c, @NonNull NetworkInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestP2pState(@NonNull Channel c, @NonNull P2pStateListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void requestPeers(Channel channel, PeerListListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setConnectionRequestResult(@NonNull Channel c, @NonNull MacAddress deviceAddress, int result, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setConnectionRequestResult(@NonNull Channel c, @NonNull MacAddress deviceAddress, int result, @Nullable String pin, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setDnsSdResponseListeners(Channel channel, DnsSdServiceResponseListener servListener, DnsSdTxtRecordListener txtListener) {
        throw new RuntimeException("Stub!");
    }

    public void setServiceResponseListener(Channel channel, ServiceResponseListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setUpnpServiceResponseListener(Channel channel, UpnpServiceResponseListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setVendorElements(@NonNull Channel c, @NonNull List<ScanResult.InformationElement> vendorElements, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setWfdInfo(@NonNull Channel channel, @NonNull WifiP2pWfdInfo wfdInfo, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void startListening(@NonNull Channel channel, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void startPeerDiscovery(@NonNull Channel channel, @NonNull WifiP2pDiscoveryConfig config, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void startUsdBasedLocalServiceAdvertisement(@NonNull Channel channel, @NonNull WifiP2pServiceInfo servInfo, @NonNull WifiP2pUsdBasedLocalServiceAdvertisementConfig config, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void stopListening(@NonNull Channel channel, @Nullable ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void stopPeerDiscovery(Channel channel, ActionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void unregisterWifiP2pListener(@NonNull WifiP2pListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void validateDirInfo(@NonNull Channel c, @NonNull WifiP2pDirInfo dirInfo, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        throw new RuntimeException("Stub!");
    }

    public static interface WifiP2pListener {
        default public void onDeviceConfigurationChanged(@Nullable WifiP2pDevice p2pDevice) {
            throw new RuntimeException("Stub!");
        }

        default public void onDiscoveryStateChanged(int state) {
            throw new RuntimeException("Stub!");
        }

        default public void onFrequencyChanged(@NonNull WifiP2pInfo p2pInfo, @NonNull WifiP2pGroup p2pGroup) {
            throw new RuntimeException("Stub!");
        }

        default public void onGroupCreated(@NonNull WifiP2pInfo p2pInfo, @NonNull WifiP2pGroup p2pGroup) {
            throw new RuntimeException("Stub!");
        }

        default public void onGroupCreating() {
            throw new RuntimeException("Stub!");
        }

        default public void onGroupCreationFailed(int reason) {
            throw new RuntimeException("Stub!");
        }

        default public void onGroupNegotiationRejectedByUser() {
            throw new RuntimeException("Stub!");
        }

        default public void onGroupRemoved() {
            throw new RuntimeException("Stub!");
        }

        default public void onListenStateChanged(int state) {
            throw new RuntimeException("Stub!");
        }

        default public void onP2pStateChanged(int state) {
            throw new RuntimeException("Stub!");
        }

        default public void onPeerClientDisconnected(@NonNull WifiP2pInfo p2pInfo, @NonNull WifiP2pGroup p2pGroup) {
            throw new RuntimeException("Stub!");
        }

        default public void onPeerClientJoined(@NonNull WifiP2pInfo p2pInfo, @NonNull WifiP2pGroup p2pGroup) {
            throw new RuntimeException("Stub!");
        }

        default public void onPeerListChanged(@NonNull WifiP2pDeviceList p2pDeviceList) {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface UpnpServiceResponseListener {
        public void onUpnpServiceAvailable(List<String> var1, WifiP2pDevice var2);
    }

    public static interface ServiceResponseListener {
        public void onServiceAvailable(int var1, byte[] var2, WifiP2pDevice var3);

        default public void onUsdBasedServiceAvailable(@NonNull WifiP2pDevice srcDevice, @NonNull WifiP2pUsdBasedServiceResponse usdResponseData) {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface PeerListListener {
        public void onPeersAvailable(WifiP2pDeviceList var1);
    }

    public static interface P2pStateListener {
        public void onP2pStateAvailable(int var1);
    }

    public static interface NetworkInfoListener {
        public void onNetworkInfoAvailable(@NonNull NetworkInfo var1);
    }

    public static interface GroupInfoListener {
        public void onGroupInfoAvailable(WifiP2pGroup var1);
    }

    public static interface ExternalApproverRequestListener {
        public static final int APPROVER_DETACH_REASON_CLOSE = 3;
        public static final int APPROVER_DETACH_REASON_FAILURE = 1;
        public static final int APPROVER_DETACH_REASON_REMOVE = 0;
        public static final int APPROVER_DETACH_REASON_REPLACE = 2;
        public static final int REQUEST_TYPE_INVITATION = 1;
        public static final int REQUEST_TYPE_JOIN = 2;
        public static final int REQUEST_TYPE_NEGOTIATION = 0;

        public void onAttached(@NonNull MacAddress var1);

        public void onConnectionRequested(int var1, @NonNull WifiP2pConfig var2, @NonNull WifiP2pDevice var3);

        public void onDetached(@NonNull MacAddress var1, int var2);

        public void onPinGenerated(@NonNull MacAddress var1, @NonNull String var2);
    }

    public static interface DnsSdTxtRecordListener {
        public void onDnsSdTxtRecordAvailable(String var1, Map<String, String> var2, WifiP2pDevice var3);
    }

    public static interface DnsSdServiceResponseListener {
        public void onDnsSdServiceAvailable(String var1, String var2, WifiP2pDevice var3);
    }

    public static interface DiscoveryStateListener {
        public void onDiscoveryStateAvailable(int var1);
    }

    public static interface DeviceInfoListener {
        public void onDeviceInfoAvailable(@Nullable WifiP2pDevice var1);
    }

    public static interface ConnectionInfoListener {
        public void onConnectionInfoAvailable(WifiP2pInfo var1);
    }

    public static interface ChannelListener {
        public void onChannelDisconnected();
    }

    public static class Channel
    implements AutoCloseable {
        Channel() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public void close() {
            throw new RuntimeException("Stub!");
        }

        protected void finalize() throws Throwable {
            throw new RuntimeException("Stub!");
        }
    }

    public static interface ActionListener {
        public void onFailure(int var1);

        public void onSuccess();
    }
}

