/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.ExtensionSessionConfiguration;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.os.Handler;
import android.view.Surface;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class CameraDevice
implements AutoCloseable {
    public static final int AUDIO_RESTRICTION_NONE = 0;
    public static final int AUDIO_RESTRICTION_VIBRATION = 1;
    public static final int AUDIO_RESTRICTION_VIBRATION_SOUND = 3;
    public static final int TEMPLATE_MANUAL = 6;
    public static final int TEMPLATE_PREVIEW = 1;
    public static final int TEMPLATE_RECORD = 3;
    public static final int TEMPLATE_STILL_CAPTURE = 2;
    public static final int TEMPLATE_VIDEO_SNAPSHOT = 4;
    public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5;

    CameraDevice() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public abstract void close();

    @NonNull
    public abstract CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

    @NonNull
    public CaptureRequest.Builder createCaptureRequest(int templateType, Set<String> physicalCameraIdSet) throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    public void createCaptureSession(SessionConfiguration config) throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public abstract void createCaptureSession(@NonNull List<Surface> var1, @NonNull CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    @Deprecated
    public abstract void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> var1, CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    @Deprecated
    public abstract void createConstrainedHighSpeedCaptureSession(@NonNull List<Surface> var1, @NonNull CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public void createExtensionSession(@NonNull ExtensionSessionConfiguration extensionConfiguration) throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public abstract CaptureRequest.Builder createReprocessCaptureRequest(@NonNull TotalCaptureResult var1) throws CameraAccessException;

    @Deprecated
    public abstract void createReprocessableCaptureSession(@NonNull InputConfiguration var1, @NonNull List<Surface> var2, @NonNull CameraCaptureSession.StateCallback var3, @Nullable Handler var4) throws CameraAccessException;

    @Deprecated
    public abstract void createReprocessableCaptureSessionByConfigurations(@NonNull InputConfiguration var1, @NonNull List<OutputConfiguration> var2, @NonNull CameraCaptureSession.StateCallback var3, @Nullable Handler var4) throws CameraAccessException;

    public int getCameraAudioRestriction() throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public abstract String getId();

    public boolean isSessionConfigurationSupported(@NonNull SessionConfiguration sessionConfig) throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    public void setCameraAudioRestriction(int mode) throws CameraAccessException {
        throw new RuntimeException("Stub!");
    }

    public static abstract class StateCallback {
        public static final int ERROR_CAMERA_DEVICE = 4;
        public static final int ERROR_CAMERA_DISABLED = 3;
        public static final int ERROR_CAMERA_IN_USE = 1;
        public static final int ERROR_CAMERA_SERVICE = 5;
        public static final int ERROR_MAX_CAMERAS_IN_USE = 2;

        public StateCallback() {
            throw new RuntimeException("Stub!");
        }

        public void onClosed(@NonNull CameraDevice camera) {
            throw new RuntimeException("Stub!");
        }

        public abstract void onDisconnected(@NonNull CameraDevice var1);

        public abstract void onError(@NonNull CameraDevice var1, int var2);

        public abstract void onOpened(@NonNull CameraDevice var1);
    }

    public static abstract class CameraDeviceSetup {
        CameraDeviceSetup() {
            throw new RuntimeException("Stub!");
        }

        @NonNull
        public abstract CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

        @NonNull
        public abstract String getId();

        @NonNull
        public abstract CameraCharacteristics getSessionCharacteristics(@NonNull SessionConfiguration var1) throws CameraAccessException;

        public abstract boolean isSessionConfigurationSupported(@NonNull SessionConfiguration var1) throws CameraAccessException;

        public abstract void openCamera(@NonNull Executor var1, @NonNull StateCallback var2) throws CameraAccessException;
    }
}

